/* jQuery Countdown - Based on: https://gist.github.com/kprimdal-dk/4701412 */
(function($) {
  $.fn.highendCountdown = function(options, callback) {

		//custom 'this' selector
		thisEl = $(this);

		//array of custom settings
		var settings = { 
			'date': null,
			'format': null
		};

		//append the settings array to options
		if(options) {
			$.extend(settings, options);
		}
		
		//main countdown function
		function countdown_proc() {
			
			eventDate = Date.parse(settings['date']) / 1000;
			currentDate = Math.floor($.now() / 1000);
			
			if(eventDate <= currentDate) {
				clearInterval(interval);
				return;
			}
			
			seconds = eventDate - currentDate;
			
			days = Math.floor(seconds / (60 * 60 * 24)); //calculate the number of days
			seconds -= days * 60 * 60 * 24; //update the seconds variable with no. of days removed
			
			hours = Math.floor(seconds / (60 * 60));
			seconds -= hours * 60 * 60; //update the seconds variable with no. of hours removed
			
			minutes = Math.floor(seconds / 60);
			seconds -= minutes * 60; //update the seconds variable with no. of minutes removed
			
			//conditional Ss
			if (days == 1) { thisEl.find(".timeRefDays").text(highend_vars.texts.day); } else { thisEl.find(".timeRefDays").text(highend_vars.texts.days); }
			if (hours == 1) { thisEl.find(".timeRefHours").text(highend_vars.texts.hour); } else { thisEl.find(".timeRefHours").text(highend_vars.texts.hours); }
			if (minutes == 1) { thisEl.find(".timeRefMinutes").text(highend_vars.texts.minute); } else { thisEl.find(".timeRefMinutes").text(highend_vars.texts.minutes); }
			if (seconds == 1) { thisEl.find(".timeRefSeconds").text(highend_vars.texts.second); } else { thisEl.find(".timeRefSeconds").text(highend_vars.texts.seconds); }
			
			//logic for the two_digits ON setting
			if(settings['format'] == "on") {
				days = (String(days).length >= 2) ? days : "0" + days;
				hours = (String(hours).length >= 2) ? hours : "0" + hours;
				minutes = (String(minutes).length >= 2) ? minutes : "0" + minutes;
				seconds = (String(seconds).length >= 2) ? seconds : "0" + seconds;
			}
			
			//update the countdown's html values.
			if(!isNaN(eventDate)) {
				thisEl.find(".days").text(days);
				thisEl.find(".hours").text(hours);
				thisEl.find(".minutes").text(minutes);
				thisEl.find(".seconds").text(seconds);
			} else { 
				clearInterval(interval); 
			}
		}
		
		//run the function
		countdown_proc();
		
		//loop the function
		var interval = setInterval(countdown_proc, 1000);
		
	}
}) (jQuery);