<?php if ( ! defined( 'ABSPATH' ) ) { die( 'Direct access forbidden.' ); }

/**
 * HB Icon Manager
 * 
 * @since 3.4.1
 */
class HB_Icon_Manager {

	/**
	 * Generate HTML output of icons for the icon picker.
	 *
	 * @since 4.0
	 */
	public static function icon_picker_modal() {

		// Run a security check
		if ( ! check_ajax_referer( 'icon-picker-nonce' ) ) {
			wp_send_json_error();
		}

		$return = '';

		// Font Awesome

		$fa_icons = HB_Icon_Manager::hb_fontawesome_class_array();

		if ( is_array( $fa_icons ) && ! empty( $fa_icons ) ) {

			$return .= '<div>';
			$return .= '<div class="iconpicker-family-title">' . esc_html__( 'FontAwesome', 'hbthemes') . ' <span>('. number_format( count($fa_icons) ) .' ' . __('icons', 'hbthemes') .') <a href="#" class="hb-toggle-icons"><span class="dashicons dashicons-arrow-down-alt2"></span></a></span></div>';
			$return .= '<ul class="wp-clearfix">';
			
			foreach ( $fa_icons as $fa_icon ) {
				$return .= '<li title="'. $fa_icon .'"><i class="' . $fa_icon . '"></i></li>';
			}
			
			$return .= '</ul>';
			$return .= '</div>';
		}

		// HB Icomoon
		$hb_moon_icons = HB_Icon_Manager::hb_moon_class_array();

		if ( is_array( $hb_moon_icons ) && ! empty( $hb_moon_icons ) ) {

			$return .= '<div>';
			$return .= '<div class="iconpicker-family-title">' . esc_html__( 'IcoMoon', 'hbthemes') . ' <span>('. number_format( count($hb_moon_icons) ) .' ' . __('icons', 'hbthemes') .') <a href="#" class="hb-toggle-icons"><span class="dashicons dashicons-arrow-down-alt2"></span></a></span></div>';
			$return .= '<ul class="wp-clearfix">';

			foreach ( $hb_moon_icons as $hb_moon_icon ) {
				$return .= '<li title="'. $hb_moon_icon .'"><i class="' . $hb_moon_icon . '"></i></li>';
			}

			$return .= '</ul>';
			$return .= '</div>';
		}

		/*
		// Visual Composer Icons
		if ( defined( 'WPB_VC_VERSION' ) ) {

			$vc_types = array();
			$vc_types = array_unique( array_merge( 
				$vc_types, 
				array( 'openiconic', 'entypo', 'typicons', 'linecons', 'monosocial', 'material' ) 
			) );

			foreach ( $vc_types as $type ) {

				$vc_icons = array();
				$vc_icons = apply_filters( 'vc_iconpicker-type-' . $type, $vc_icons );

				if ( is_array( $vc_icons ) && ! empty( $vc_icons ) ) {

					$return .= '<div>';
					$return .= '<div class="icon-family-title">' . ucfirst( $type ) . '<span>(' . number_format( count( $vc_icons ) ) . ' ' . esc_html__( 'icons', 'hbthemes' ) . ') <a href="#" class="hb-toggle-icons"><span class="dashicons dashicons-arrow-down-alt2"></span></a></span></div>';

					$return .= '<ul class="wp-clearfix">';

					foreach ( $vc_icons as $group => $icon_list ) {

						if ( ! is_array( $icon_list ) || ! is_array( current( $icon_list ) ) ) {
							$class_key 	 = key( $icon_list );
							$return 	.= '<li title="' . $class_key . '"><i class="' . $class_key . '"></i></li>';
						} else {
							foreach ( $icon_list as $key => $value ) {
								$class_key 	 = key( $value );
								$return 	.= '<li title="'. $class_key .'"><i class="' . $class_key . '"></i></li>';
							}
						}
					}

					$return .= '</ul>';
					$return .= '</div>';
				}
			}
		}
		*/

		// Other Icons
		wp_send_json_success( array( 'html' => $return ) );
	}	

	/**
	 * Returns an array of Font Awesome icon classes.
	 *
	 * @return array of fontawesome icon classes
	 * @since 4.0
	 */
	public static function hb_fontawesome_class_array() {

		return array (
			0 => 'icon-500px',
			1 => 'icon-address-book',
			2 => 'icon-address-book-o',
			3 => 'icon-address-card',
			4 => 'icon-address-card-o',
			5 => 'icon-adjust',
			6 => 'icon-adn',
			7 => 'icon-align-center',
			8 => 'icon-align-justify',
			9 => 'icon-align-left',
			10 => 'icon-align-right',
			11 => 'icon-amazon',
			12 => 'icon-ambulance',
			13 => 'icon-american-sign-language-interpreting',
			14 => 'icon-anchor',
			15 => 'icon-android',
			16 => 'icon-angellist',
			17 => 'icon-angle-double-down',
			18 => 'icon-angle-double-left',
			19 => 'icon-angle-double-right',
			20 => 'icon-angle-double-up',
			21 => 'icon-angle-down',
			22 => 'icon-angle-left',
			23 => 'icon-angle-right',
			24 => 'icon-angle-up',
			25 => 'icon-apple',
			26 => 'icon-archive',
			27 => 'icon-area-chart',
			28 => 'icon-arrow-circle-down',
			29 => 'icon-arrow-circle-left',
			30 => 'icon-arrow-circle-o-down',
			31 => 'icon-arrow-circle-o-left',
			32 => 'icon-arrow-circle-o-right',
			33 => 'icon-arrow-circle-o-up',
			34 => 'icon-arrow-circle-right',
			35 => 'icon-arrow-circle-up',
			36 => 'icon-arrow-down',
			37 => 'icon-arrow-left',
			38 => 'icon-arrow-right',
			39 => 'icon-arrow-up',
			40 => 'icon-arrows',
			41 => 'icon-arrows-alt',
			42 => 'icon-arrows-h',
			43 => 'icon-arrows-v',
			44 => 'icon-asl-interpreting',
			45 => 'icon-assistive-listening-systems',
			46 => 'icon-asterisk',
			47 => 'icon-at',
			48 => 'icon-audio-description',
			49 => 'icon-automobile',
			50 => 'icon-backward',
			51 => 'icon-balance-scale',
			52 => 'icon-ban',
			53 => 'icon-bandcamp',
			54 => 'icon-bank',
			55 => 'icon-bar-chart',
			56 => 'icon-bar-chart-o',
			57 => 'icon-barcode',
			58 => 'icon-bars',
			59 => 'icon-bath',
			60 => 'icon-bathtub',
			61 => 'icon-battery',
			62 => 'icon-battery-0',
			63 => 'icon-battery-1',
			64 => 'icon-battery-2',
			65 => 'icon-battery-3',
			66 => 'icon-battery-4',
			67 => 'icon-battery-empty',
			68 => 'icon-battery-full',
			69 => 'icon-battery-half',
			70 => 'icon-battery-quarter',
			71 => 'icon-battery-three-quarters',
			72 => 'icon-bed',
			73 => 'icon-beer',
			74 => 'icon-behance',
			75 => 'icon-behance-square',
			76 => 'icon-bell',
			77 => 'icon-bell-o',
			78 => 'icon-bell-slash',
			79 => 'icon-bell-slash-o',
			80 => 'icon-bicycle',
			81 => 'icon-binoculars',
			82 => 'icon-birthday-cake',
			83 => 'icon-bitbucket',
			84 => 'icon-bitbucket-square',
			85 => 'icon-bitcoin',
			86 => 'icon-black-tie',
			87 => 'icon-blind',
			88 => 'icon-bluetooth',
			89 => 'icon-bluetooth-b',
			90 => 'icon-bold',
			91 => 'icon-bolt',
			92 => 'icon-bomb',
			93 => 'icon-book',
			94 => 'icon-bookmark',
			95 => 'icon-bookmark-o',
			96 => 'icon-braille',
			97 => 'icon-briefcase',
			98 => 'icon-btc',
			99 => 'icon-bug',
			100 => 'icon-building',
			101 => 'icon-building-o',
			102 => 'icon-bullhorn',
			103 => 'icon-bullseye',
			104 => 'icon-bus',
			105 => 'icon-buysellads',
			106 => 'icon-cab',
			107 => 'icon-calculator',
			108 => 'icon-calendar',
			109 => 'icon-calendar-check-o',
			110 => 'icon-calendar-minus-o',
			111 => 'icon-calendar-o',
			112 => 'icon-calendar-plus-o',
			113 => 'icon-calendar-times-o',
			114 => 'icon-camera',
			115 => 'icon-camera-retro',
			116 => 'icon-car',
			117 => 'icon-caret-down',
			118 => 'icon-caret-left',
			119 => 'icon-caret-right',
			120 => 'icon-caret-square-o-down',
			121 => 'icon-caret-square-o-left',
			122 => 'icon-caret-square-o-right',
			123 => 'icon-caret-square-o-up',
			124 => 'icon-caret-up',
			125 => 'icon-cart-arrow-down',
			126 => 'icon-cart-plus',
			127 => 'icon-cc',
			128 => 'icon-cc-amex',
			129 => 'icon-cc-diners-club',
			130 => 'icon-cc-discover',
			131 => 'icon-cc-jcb',
			132 => 'icon-cc-mastercard',
			133 => 'icon-cc-paypal',
			134 => 'icon-cc-stripe',
			135 => 'icon-cc-visa',
			136 => 'icon-certificate',
			137 => 'icon-chain',
			138 => 'icon-chain-broken',
			139 => 'icon-check',
			140 => 'icon-check-circle',
			141 => 'icon-check-circle-o',
			142 => 'icon-check-square',
			143 => 'icon-check-square-o',
			144 => 'icon-chevron-circle-down',
			145 => 'icon-chevron-circle-left',
			146 => 'icon-chevron-circle-right',
			147 => 'icon-chevron-circle-up',
			148 => 'icon-chevron-down',
			149 => 'icon-chevron-left',
			150 => 'icon-chevron-right',
			151 => 'icon-chevron-up',
			152 => 'icon-child',
			153 => 'icon-chrome',
			154 => 'icon-circle',
			155 => 'icon-circle-o',
			156 => 'icon-circle-o-notch',
			157 => 'icon-circle-thin',
			158 => 'icon-clipboard',
			159 => 'icon-clock-o',
			160 => 'icon-clone',
			161 => 'icon-close',
			162 => 'icon-cloud',
			163 => 'icon-cloud-download',
			164 => 'icon-cloud-upload',
			165 => 'icon-cny',
			166 => 'icon-code',
			167 => 'icon-code-fork',
			168 => 'icon-codepen',
			169 => 'icon-codiepie',
			170 => 'icon-coffee',
			171 => 'icon-cog',
			172 => 'icon-cogs',
			173 => 'icon-columns',
			174 => 'icon-comment',
			175 => 'icon-comment-o',
			176 => 'icon-commenting',
			177 => 'icon-commenting-o',
			178 => 'icon-comments',
			179 => 'icon-comments-o',
			180 => 'icon-compass',
			181 => 'icon-compress',
			182 => 'icon-connectdevelop',
			183 => 'icon-contao',
			184 => 'icon-copy',
			185 => 'icon-copyright',
			186 => 'icon-creative-commons',
			187 => 'icon-credit-card',
			188 => 'icon-credit-card-alt',
			189 => 'icon-crop',
			190 => 'icon-crosshairs',
			191 => 'icon-css3',
			192 => 'icon-cube',
			193 => 'icon-cubes',
			194 => 'icon-cut',
			195 => 'icon-cutlery',
			196 => 'icon-dashboard',
			197 => 'icon-dashcube',
			198 => 'icon-database',
			199 => 'icon-deaf',
			200 => 'icon-deafness',
			201 => 'icon-dedent',
			202 => 'icon-delicious',
			203 => 'icon-desktop',
			204 => 'icon-deviantart',
			205 => 'icon-diamond',
			206 => 'icon-digg',
			207 => 'icon-dollar',
			208 => 'icon-dot-circle-o',
			209 => 'icon-download',
			210 => 'icon-dribbble',
			211 => 'icon-drivers-license',
			212 => 'icon-drivers-license-o',
			213 => 'icon-dropbox',
			214 => 'icon-drupal',
			215 => 'icon-edge',
			216 => 'icon-edit',
			217 => 'icon-eercast',
			218 => 'icon-eject',
			219 => 'icon-ellipsis-h',
			220 => 'icon-ellipsis-v',
			221 => 'icon-empire',
			222 => 'icon-envelope',
			223 => 'icon-envelope-o',
			224 => 'icon-envelope-open',
			225 => 'icon-envelope-open-o',
			226 => 'icon-envelope-square',
			227 => 'icon-envira',
			228 => 'icon-eraser',
			229 => 'icon-etsy',
			230 => 'icon-eur',
			231 => 'icon-euro',
			232 => 'icon-exchange',
			233 => 'icon-exclamation',
			234 => 'icon-exclamation-circle',
			235 => 'icon-exclamation-triangle',
			236 => 'icon-expand',
			237 => 'icon-expeditedssl',
			238 => 'icon-external-link',
			239 => 'icon-external-link-square',
			240 => 'icon-eye',
			241 => 'icon-eye-slash',
			242 => 'icon-eyedropper',
			243 => 'icon-fa',
			244 => 'icon-facebook',
			245 => 'icon-facebook-f',
			246 => 'icon-facebook-official',
			247 => 'icon-facebook-square',
			248 => 'icon-fast-backward',
			249 => 'icon-fast-forward',
			250 => 'icon-fax',
			251 => 'icon-feed',
			252 => 'icon-female',
			253 => 'icon-fighter-jet',
			254 => 'icon-file',
			255 => 'icon-file-archive-o',
			256 => 'icon-file-audio-o',
			257 => 'icon-file-code-o',
			258 => 'icon-file-excel-o',
			259 => 'icon-file-image-o',
			260 => 'icon-file-movie-o',
			261 => 'icon-file-o',
			262 => 'icon-file-pdf-o',
			263 => 'icon-file-photo-o',
			264 => 'icon-file-picture-o',
			265 => 'icon-file-powerpoint-o',
			266 => 'icon-file-sound-o',
			267 => 'icon-file-text',
			268 => 'icon-file-text-o',
			269 => 'icon-file-video-o',
			270 => 'icon-file-word-o',
			271 => 'icon-file-zip-o',
			272 => 'icon-files-o',
			273 => 'icon-film',
			274 => 'icon-filter',
			275 => 'icon-fire',
			276 => 'icon-fire-extinguisher',
			277 => 'icon-firefox',
			278 => 'icon-first-order',
			279 => 'icon-flag',
			280 => 'icon-flag-checkered',
			281 => 'icon-flag-o',
			282 => 'icon-flash',
			283 => 'icon-flask',
			284 => 'icon-flickr',
			285 => 'icon-floppy-o',
			286 => 'icon-folder',
			287 => 'icon-folder-o',
			288 => 'icon-folder-open',
			289 => 'icon-folder-open-o',
			290 => 'icon-font',
			291 => 'icon-font-awesome',
			292 => 'icon-fonticons',
			293 => 'icon-fort-awesome',
			294 => 'icon-forumbee',
			295 => 'icon-forward',
			296 => 'icon-foursquare',
			297 => 'icon-free-code-camp',
			298 => 'icon-frown-o',
			299 => 'icon-futbol-o',
			300 => 'icon-gamepad',
			301 => 'icon-gavel',
			302 => 'icon-gbp',
			303 => 'icon-ge',
			304 => 'icon-gear',
			305 => 'icon-gears',
			306 => 'icon-genderless',
			307 => 'icon-get-pocket',
			308 => 'icon-gg',
			309 => 'icon-gg-circle',
			310 => 'icon-gift',
			311 => 'icon-git',
			312 => 'icon-git-square',
			313 => 'icon-github',
			314 => 'icon-github-alt',
			315 => 'icon-github-square',
			316 => 'icon-gitlab',
			317 => 'icon-gittip',
			318 => 'icon-glass',
			319 => 'icon-glide',
			320 => 'icon-glide-g',
			321 => 'icon-globe',
			322 => 'icon-google',
			323 => 'icon-google-plus',
			324 => 'icon-google-plus-circle',
			325 => 'icon-google-plus-official',
			326 => 'icon-google-plus-square',
			327 => 'icon-google-wallet',
			328 => 'icon-graduation-cap',
			329 => 'icon-gratipay',
			330 => 'icon-grav',
			331 => 'icon-group',
			332 => 'icon-h-square',
			333 => 'icon-hacker-news',
			334 => 'icon-hand-grab-o',
			335 => 'icon-hand-lizard-o',
			336 => 'icon-hand-o-down',
			337 => 'icon-hand-o-left',
			338 => 'icon-hand-o-right',
			339 => 'icon-hand-o-up',
			340 => 'icon-hand-paper-o',
			341 => 'icon-hand-peace-o',
			342 => 'icon-hand-pointer-o',
			343 => 'icon-hand-rock-o',
			344 => 'icon-hand-scissors-o',
			345 => 'icon-hand-spock-o',
			346 => 'icon-hand-stop-o',
			347 => 'icon-handshake-o',
			348 => 'icon-hard-of-hearing',
			349 => 'icon-hashtag',
			350 => 'icon-hdd-o',
			351 => 'icon-header',
			352 => 'icon-headphones',
			353 => 'icon-heart',
			354 => 'icon-heart-o',
			355 => 'icon-heartbeat',
			356 => 'icon-history',
			357 => 'icon-home',
			358 => 'icon-hospital-o',
			359 => 'icon-hotel',
			360 => 'icon-hourglass',
			361 => 'icon-hourglass-1',
			362 => 'icon-hourglass-2',
			363 => 'icon-hourglass-3',
			364 => 'icon-hourglass-end',
			365 => 'icon-hourglass-half',
			366 => 'icon-hourglass-o',
			367 => 'icon-hourglass-start',
			368 => 'icon-houzz',
			369 => 'icon-html5',
			370 => 'icon-i-cursor',
			371 => 'icon-id-badge',
			372 => 'icon-id-card',
			373 => 'icon-id-card-o',
			374 => 'icon-ils',
			375 => 'icon-image',
			376 => 'icon-imdb',
			377 => 'icon-inbox',
			378 => 'icon-indent',
			379 => 'icon-industry',
			380 => 'icon-info',
			381 => 'icon-info-circle',
			382 => 'icon-inr',
			383 => 'icon-instagram',
			384 => 'icon-institution',
			385 => 'icon-internet-explorer',
			386 => 'icon-intersex',
			387 => 'icon-ioxhost',
			388 => 'icon-italic',
			389 => 'icon-joomla',
			390 => 'icon-jpy',
			391 => 'icon-jsfiddle',
			392 => 'icon-key',
			393 => 'icon-keyboard-o',
			394 => 'icon-krw',
			395 => 'icon-language',
			396 => 'icon-laptop',
			397 => 'icon-lastfm',
			398 => 'icon-lastfm-square',
			399 => 'icon-leaf',
			400 => 'icon-leanpub',
			401 => 'icon-legal',
			402 => 'icon-lemon-o',
			403 => 'icon-level-down',
			404 => 'icon-level-up',
			405 => 'icon-life-bouy',
			406 => 'icon-life-buoy',
			407 => 'icon-life-ring',
			408 => 'icon-life-saver',
			409 => 'icon-lightbulb-o',
			410 => 'icon-line-chart',
			411 => 'icon-link',
			412 => 'icon-linkedin',
			413 => 'icon-linkedin-square',
			414 => 'icon-linode',
			415 => 'icon-linux',
			416 => 'icon-list',
			417 => 'icon-list-alt',
			418 => 'icon-list-ol',
			419 => 'icon-list-ul',
			420 => 'icon-location-arrow',
			421 => 'icon-lock',
			422 => 'icon-long-arrow-down',
			423 => 'icon-long-arrow-left',
			424 => 'icon-long-arrow-right',
			425 => 'icon-long-arrow-up',
			426 => 'icon-low-vision',
			427 => 'icon-magic',
			428 => 'icon-magnet',
			429 => 'icon-mail-forward',
			430 => 'icon-mail-reply',
			431 => 'icon-mail-reply-all',
			432 => 'icon-male',
			433 => 'icon-map',
			434 => 'icon-map-marker',
			435 => 'icon-map-o',
			436 => 'icon-map-pin',
			437 => 'icon-map-signs',
			438 => 'icon-mars',
			439 => 'icon-mars-double',
			440 => 'icon-mars-stroke',
			441 => 'icon-mars-stroke-h',
			442 => 'icon-mars-stroke-v',
			443 => 'icon-maxcdn',
			444 => 'icon-meanpath',
			445 => 'icon-medium',
			446 => 'icon-medkit',
			447 => 'icon-meetup',
			448 => 'icon-meh-o',
			449 => 'icon-mercury',
			450 => 'icon-microchip',
			451 => 'icon-microphone',
			452 => 'icon-microphone-slash',
			453 => 'icon-minus',
			454 => 'icon-minus-circle',
			455 => 'icon-minus-square',
			456 => 'icon-minus-square-o',
			457 => 'icon-mixcloud',
			458 => 'icon-mobile',
			459 => 'icon-mobile-phone',
			460 => 'icon-modx',
			461 => 'icon-money',
			462 => 'icon-moon-o',
			463 => 'icon-mortar-board',
			464 => 'icon-motorcycle',
			465 => 'icon-mouse-pointer',
			466 => 'icon-music',
			467 => 'icon-navicon',
			468 => 'icon-neuter',
			469 => 'icon-newspaper-o',
			470 => 'icon-object-group',
			471 => 'icon-object-ungroup',
			472 => 'icon-odnoklassniki',
			473 => 'icon-odnoklassniki-square',
			474 => 'icon-opencart',
			475 => 'icon-openid',
			476 => 'icon-opera',
			477 => 'icon-optin-monster',
			478 => 'icon-outdent',
			479 => 'icon-pagelines',
			480 => 'icon-paint-brush',
			481 => 'icon-paper-plane',
			482 => 'icon-paper-plane-o',
			483 => 'icon-paperclip',
			484 => 'icon-paragraph',
			485 => 'icon-paste',
			486 => 'icon-pause',
			487 => 'icon-pause-circle',
			488 => 'icon-pause-circle-o',
			489 => 'icon-paw',
			490 => 'icon-paypal',
			491 => 'icon-pencil',
			492 => 'icon-pencil-square',
			493 => 'icon-pencil-square-o',
			494 => 'icon-percent',
			495 => 'icon-phone',
			496 => 'icon-phone-square',
			497 => 'icon-photo',
			498 => 'icon-picture-o',
			499 => 'icon-pie-chart',
			500 => 'icon-pied-piper',
			501 => 'icon-pied-piper-alt',
			502 => 'icon-pied-piper-pp',
			503 => 'icon-pinterest',
			504 => 'icon-pinterest-p',
			505 => 'icon-pinterest-square',
			506 => 'icon-plane',
			507 => 'icon-play',
			508 => 'icon-play-circle',
			509 => 'icon-play-circle-o',
			510 => 'icon-plug',
			511 => 'icon-plus',
			512 => 'icon-plus-circle',
			513 => 'icon-plus-square',
			514 => 'icon-plus-square-o',
			515 => 'icon-podcast',
			516 => 'icon-power-off',
			517 => 'icon-print',
			518 => 'icon-product-hunt',
			519 => 'icon-puzzle-piece',
			520 => 'icon-qq',
			521 => 'icon-qrcode',
			522 => 'icon-question',
			523 => 'icon-question-circle',
			524 => 'icon-question-circle-o',
			525 => 'icon-quora',
			526 => 'icon-quote-left',
			527 => 'icon-quote-right',
			528 => 'icon-ra',
			529 => 'icon-random',
			530 => 'icon-ravelry',
			531 => 'icon-rebel',
			532 => 'icon-recycle',
			533 => 'icon-reddit',
			534 => 'icon-reddit-alien',
			535 => 'icon-reddit-square',
			536 => 'icon-refresh',
			537 => 'icon-registered',
			538 => 'icon-remove',
			539 => 'icon-renren',
			540 => 'icon-reorder',
			541 => 'icon-repeat',
			542 => 'icon-reply',
			543 => 'icon-reply-all',
			544 => 'icon-resistance',
			545 => 'icon-retweet',
			546 => 'icon-rmb',
			547 => 'icon-road',
			548 => 'icon-rocket',
			549 => 'icon-rotate-left',
			550 => 'icon-rotate-right',
			551 => 'icon-rouble',
			552 => 'icon-rss',
			553 => 'icon-rss-square',
			554 => 'icon-rub',
			555 => 'icon-ruble',
			556 => 'icon-rupee',
			557 => 'icon-s15',
			558 => 'icon-safari',
			559 => 'icon-save',
			560 => 'icon-scissors',
			561 => 'icon-scribd',
			562 => 'icon-search',
			563 => 'icon-search-minus',
			564 => 'icon-search-plus',
			565 => 'icon-sellsy',
			566 => 'icon-send',
			567 => 'icon-send-o',
			568 => 'icon-server',
			569 => 'icon-share',
			570 => 'icon-share-alt',
			571 => 'icon-share-alt-square',
			572 => 'icon-share-square',
			573 => 'icon-share-square-o',
			574 => 'icon-shekel',
			575 => 'icon-sheqel',
			576 => 'icon-shield',
			577 => 'icon-ship',
			578 => 'icon-shirtsinbulk',
			579 => 'icon-shopping-bag',
			580 => 'icon-shopping-basket',
			581 => 'icon-shopping-cart',
			582 => 'icon-shower',
			583 => 'icon-sign-in',
			584 => 'icon-sign-language',
			585 => 'icon-sign-out',
			586 => 'icon-signal',
			587 => 'icon-signing',
			588 => 'icon-simplybuilt',
			589 => 'icon-sitemap',
			590 => 'icon-skyatlas',
			591 => 'icon-skype',
			592 => 'icon-slack',
			593 => 'icon-sliders',
			594 => 'icon-slideshare',
			595 => 'icon-smile-o',
			596 => 'icon-snapchat',
			597 => 'icon-snapchat-ghost',
			598 => 'icon-snapchat-square',
			599 => 'icon-snowflake-o',
			600 => 'icon-soccer-ball-o',
			601 => 'icon-sort',
			602 => 'icon-sort-alpha-asc',
			603 => 'icon-sort-alpha-desc',
			604 => 'icon-sort-amount-asc',
			605 => 'icon-sort-amount-desc',
			606 => 'icon-sort-asc',
			607 => 'icon-sort-desc',
			608 => 'icon-sort-down',
			609 => 'icon-sort-numeric-asc',
			610 => 'icon-sort-numeric-desc',
			611 => 'icon-sort-up',
			612 => 'icon-soundcloud',
			613 => 'icon-space-shuttle',
			614 => 'icon-spinner',
			615 => 'icon-spoon',
			616 => 'icon-spotify',
			617 => 'icon-square',
			618 => 'icon-square-o',
			619 => 'icon-stack-exchange',
			620 => 'icon-stack-overflow',
			621 => 'icon-star',
			622 => 'icon-star-half',
			623 => 'icon-star-half-empty',
			624 => 'icon-star-half-full',
			625 => 'icon-star-half-o',
			626 => 'icon-star-o',
			627 => 'icon-steam',
			628 => 'icon-steam-square',
			629 => 'icon-step-backward',
			630 => 'icon-step-forward',
			631 => 'icon-stethoscope',
			632 => 'icon-sticky-note',
			633 => 'icon-sticky-note-o',
			634 => 'icon-stop',
			635 => 'icon-stop-circle',
			636 => 'icon-stop-circle-o',
			637 => 'icon-street-view',
			638 => 'icon-strikethrough',
			639 => 'icon-stumbleupon',
			640 => 'icon-stumbleupon-circle',
			641 => 'icon-subscript',
			642 => 'icon-subway',
			643 => 'icon-suitcase',
			644 => 'icon-sun-o',
			645 => 'icon-superpowers',
			646 => 'icon-superscript',
			647 => 'icon-support',
			648 => 'icon-table',
			649 => 'icon-tablet',
			650 => 'icon-tachometer',
			651 => 'icon-tag',
			652 => 'icon-tags',
			653 => 'icon-tasks',
			654 => 'icon-taxi',
			655 => 'icon-telegram',
			656 => 'icon-television',
			657 => 'icon-tencent-weibo',
			658 => 'icon-terminal',
			659 => 'icon-text-height',
			660 => 'icon-text-width',
			661 => 'icon-th',
			662 => 'icon-th-large',
			663 => 'icon-th-list',
			664 => 'icon-themeisle',
			665 => 'icon-thermometer',
			666 => 'icon-thermometer-0',
			667 => 'icon-thermometer-1',
			668 => 'icon-thermometer-2',
			669 => 'icon-thermometer-3',
			670 => 'icon-thermometer-4',
			671 => 'icon-thermometer-empty',
			672 => 'icon-thermometer-full',
			673 => 'icon-thermometer-half',
			674 => 'icon-thermometer-quarter',
			675 => 'icon-thermometer-three-quarters',
			676 => 'icon-thumb-tack',
			677 => 'icon-thumbs-down',
			678 => 'icon-thumbs-o-down',
			679 => 'icon-thumbs-o-up',
			680 => 'icon-thumbs-up',
			681 => 'icon-ticket',
			682 => 'icon-times',
			683 => 'icon-times-circle',
			684 => 'icon-times-circle-o',
			685 => 'icon-times-rectangle',
			686 => 'icon-times-rectangle-o',
			687 => 'icon-tint',
			688 => 'icon-toggle-down',
			689 => 'icon-toggle-left',
			690 => 'icon-toggle-off',
			691 => 'icon-toggle-on',
			692 => 'icon-toggle-right',
			693 => 'icon-toggle-up',
			694 => 'icon-trademark',
			695 => 'icon-train',
			696 => 'icon-transgender',
			697 => 'icon-transgender-alt',
			698 => 'icon-trash',
			699 => 'icon-trash-o',
			700 => 'icon-tree',
			701 => 'icon-trello',
			702 => 'icon-tripadvisor',
			703 => 'icon-trophy',
			704 => 'icon-truck',
			705 => 'icon-try',
			706 => 'icon-tty',
			707 => 'icon-tumblr',
			708 => 'icon-tumblr-square',
			709 => 'icon-turkish-lira',
			710 => 'icon-tv',
			711 => 'icon-twitch',
			712 => 'icon-twitter',
			713 => 'icon-twitter-square',
			714 => 'icon-umbrella',
			715 => 'icon-underline',
			716 => 'icon-undo',
			717 => 'icon-universal-access',
			718 => 'icon-university',
			719 => 'icon-unlink',
			720 => 'icon-unlock',
			721 => 'icon-unlock-alt',
			722 => 'icon-unsorted',
			723 => 'icon-upload',
			724 => 'icon-usb',
			725 => 'icon-usd',
			726 => 'icon-user',
			727 => 'icon-user-circle',
			728 => 'icon-user-circle-o',
			729 => 'icon-user-md',
			730 => 'icon-user-o',
			731 => 'icon-user-plus',
			732 => 'icon-user-secret',
			733 => 'icon-user-times',
			734 => 'icon-users',
			735 => 'icon-vcard',
			736 => 'icon-vcard-o',
			737 => 'icon-venus',
			738 => 'icon-venus-double',
			739 => 'icon-venus-mars',
			740 => 'icon-viacoin',
			741 => 'icon-viadeo',
			742 => 'icon-viadeo-square',
			743 => 'icon-video-camera',
			744 => 'icon-vimeo',
			745 => 'icon-vimeo-square',
			746 => 'icon-vine',
			747 => 'icon-vk',
			748 => 'icon-volume-control-phone',
			749 => 'icon-volume-down',
			750 => 'icon-volume-off',
			751 => 'icon-volume-up',
			752 => 'icon-warning',
			753 => 'icon-wechat',
			754 => 'icon-weibo',
			755 => 'icon-weixin',
			756 => 'icon-whatsapp',
			757 => 'icon-wheelchair',
			758 => 'icon-wheelchair-alt',
			759 => 'icon-wifi',
			760 => 'icon-wikipedia-w',
			761 => 'icon-window-close',
			762 => 'icon-window-close-o',
			763 => 'icon-window-maximize',
			764 => 'icon-window-minimize',
			765 => 'icon-window-restore',
			766 => 'icon-windows',
			767 => 'icon-won',
			768 => 'icon-wordpress',
			769 => 'icon-wpbeginner',
			770 => 'icon-wpexplorer',
			771 => 'icon-wpforms',
			772 => 'icon-wrench',
			773 => 'icon-xing',
			774 => 'icon-xing-square',
			775 => 'icon-y-combinator',
			776 => 'icon-y-combinator-square',
			777 => 'icon-yahoo',
			778 => 'icon-yc',
			779 => 'icon-yc-square',
			780 => 'icon-yelp',
			781 => 'icon-yen',
			782 => 'icon-yoast',
			783 => 'icon-youtube',
			784 => 'icon-youtube-play',
			785 => 'icon-youtube-square',
		);
	}

	/**
	 * Returns an array Icomoon icon classes
	 *
	 * @return array of icomoon icon classes
	 * @since 4.0
	 */
	public static function hb_moon_class_array() {

		return array(
			'hb-moon-accessibility',
			'hb-moon-accessibility-2',
			'hb-moon-address-book',
			'hb-moon-address-book-2',
			'hb-moon-aid',
			'hb-moon-airplane',
			'hb-moon-airplane-2',
			'hb-moon-alarm',
			'hb-moon-alarm-2',
			'hb-moon-alarm-cancel',
			'hb-moon-alarm-check',
			'hb-moon-alarm-minus',
			'hb-moon-alarm-plus',
			'hb-moon-align-bottom',
			'hb-moon-align-center-horizontal',
			'hb-moon-align-center-vertical',
			'hb-moon-align-left',
			'hb-moon-align-right',
			'hb-moon-align-top',
			'hb-moon-anchor',
			'hb-moon-android',
			'hb-moon-angry',
			'hb-moon-angry-2',
			'hb-moon-apple',
			'hb-moon-apple-fruit',
			'hb-moon-archive',
			'hb-moon-arrow',
			'hb-moon-arrow-2',
			'hb-moon-arrow-3',
			'hb-moon-arrow-4',
			'hb-moon-arrow-5',
			'hb-moon-arrow-6',
			'hb-moon-arrow-7',
			'hb-moon-arrow-8',
			'hb-moon-arrow-bottom',
			'hb-moon-arrow-down',
			'hb-moon-arrow-down-10',
			'hb-moon-arrow-down-11',
			'hb-moon-arrow-down-12',
			'hb-moon-arrow-down-13',
			'hb-moon-arrow-down-14',
			'hb-moon-arrow-down-15',
			'hb-moon-arrow-down-16',
			'hb-moon-arrow-down-2',
			'hb-moon-arrow-down-3',
			'hb-moon-arrow-down-4',
			'hb-moon-arrow-down-5',
			'hb-moon-arrow-down-6',
			'hb-moon-arrow-down-7',
			'hb-moon-arrow-down-8',
			'hb-moon-arrow-down-9',
			'hb-moon-arrow-down-left',
			'hb-moon-arrow-down-left-2',
			'hb-moon-arrow-down-left-3',
			'hb-moon-arrow-down-left-4',
			'hb-moon-arrow-down-left-5',
			'hb-moon-arrow-down-left-6',
			'hb-moon-arrow-down-left-7',
			'hb-moon-arrow-down-right',
			'hb-moon-arrow-down-right-2',
			'hb-moon-arrow-down-right-3',
			'hb-moon-arrow-down-right-4',
			'hb-moon-arrow-down-right-5',
			'hb-moon-arrow-down-right-6',
			'hb-moon-arrow-down-right-7',
			'hb-moon-arrow-first',
			'hb-moon-arrow-left',
			'hb-moon-arrow-left-10',
			'hb-moon-arrow-left-11',
			'hb-moon-arrow-left-12',
			'hb-moon-arrow-left-13',
			'hb-moon-arrow-left-14',
			'hb-moon-arrow-left-15',
			'hb-moon-arrow-left-16',
			'hb-moon-arrow-left-17',
			'hb-moon-arrow-left-2',
			'hb-moon-arrow-left-3',
			'hb-moon-arrow-left-4',
			'hb-moon-arrow-left-5',
			'hb-moon-arrow-left-6',
			'hb-moon-arrow-left-7',
			'hb-moon-arrow-left-8',
			'hb-moon-arrow-left-9',
			'hb-moon-arrow-right',
			'hb-moon-arrow-right-10',
			'hb-moon-arrow-right-11',
			'hb-moon-arrow-right-12',
			'hb-moon-arrow-right-13',
			'hb-moon-arrow-right-14',
			'hb-moon-arrow-right-15',
			'hb-moon-arrow-right-16',
			'hb-moon-arrow-right-17',
			'hb-moon-arrow-right-18',
			'hb-moon-arrow-right-2',
			'hb-moon-arrow-right-3',
			'hb-moon-arrow-right-4',
			'hb-moon-arrow-right-5',
			'hb-moon-arrow-right-6',
			'hb-moon-arrow-right-7',
			'hb-moon-arrow-right-8',
			'hb-moon-arrow-right-9',
			'hb-moon-arrow-square',
			'hb-moon-arrow-up',
			'hb-moon-arrow-up-10',
			'hb-moon-arrow-up-11',
			'hb-moon-arrow-up-12',
			'hb-moon-arrow-up-13',
			'hb-moon-arrow-up-14',
			'hb-moon-arrow-up-15',
			'hb-moon-arrow-up-16',
			'hb-moon-arrow-up-2',
			'hb-moon-arrow-up-3',
			'hb-moon-arrow-up-4',
			'hb-moon-arrow-up-5',
			'hb-moon-arrow-up-6',
			'hb-moon-arrow-up-7',
			'hb-moon-arrow-up-8',
			'hb-moon-arrow-up-9',
			'hb-moon-arrow-up-left',
			'hb-moon-arrow-up-left-2',
			'hb-moon-arrow-up-left-3',
			'hb-moon-arrow-up-left-4',
			'hb-moon-arrow-up-left-5',
			'hb-moon-arrow-up-left-6',
			'hb-moon-arrow-up-left-7',
			'hb-moon-arrow-up-right',
			'hb-moon-arrow-up-right-2',
			'hb-moon-arrow-up-right-3',
			'hb-moon-arrow-up-right-4',
			'hb-moon-arrow-up-right-5',
			'hb-moon-arrow-up-right-6',
			'hb-moon-arrow-up-right-7',
			'hb-moon-atom',
			'hb-moon-atom-2',
			'hb-moon-attachment',
			'hb-moon-attachment-2',
			'hb-moon-backspace',
			'hb-moon-backspace-2',
			'hb-moon-backspace-3',
			'hb-moon-backward',
			'hb-moon-backward-2',
			'hb-moon-bag',
			'hb-moon-bag-2',
			'hb-moon-bag-3',
			'hb-moon-balance',
			'hb-moon-balloon',
			'hb-moon-barcode',
			'hb-moon-barcode-2',
			'hb-moon-bars',
			'hb-moon-bars-2',
			'hb-moon-bars-3',
			'hb-moon-bars-4',
			'hb-moon-bars-5',
			'hb-moon-bars-6',
			'hb-moon-baseball',
			'hb-moon-basket',
			'hb-moon-basket-2',
			'hb-moon-basketball',
			'hb-moon-bed',
			'hb-moon-bed-2',
			'hb-moon-bell',
			'hb-moon-bell-2',
			'hb-moon-bike',
			'hb-moon-binoculars',
			'hb-moon-binoculars-2',
			'hb-moon-bishop',
			'hb-moon-blocked',
			'hb-moon-blog',
			'hb-moon-blog-2',
			'hb-moon-blogger',
			'hb-moon-blogger-2',
			'hb-moon-boat',
			'hb-moon-bold',
			'hb-moon-bold-2',
			'hb-moon-bomb',
			'hb-moon-book',
			'hb-moon-book-2',
			'hb-moon-bookmark',
			'hb-moon-bookmark-2',
			'hb-moon-bookmark-3',
			'hb-moon-bookmarks',
			'hb-moon-books',
			'hb-moon-bottle',
			'hb-moon-bottle-2',
			'hb-moon-bowling',
			'hb-moon-bowling-2',
			'hb-moon-bowling-ball',
			'hb-moon-box',
			'hb-moon-box-add',
			'hb-moon-box-remove',
			'hb-moon-brain',
			'hb-moon-briefcase',
			'hb-moon-briefcase-2',
			'hb-moon-briefcase-3',
			'hb-moon-brightness-contrast',
			'hb-moon-brightness-high',
			'hb-moon-brightness-low',
			'hb-moon-brightness-medium',
			'hb-moon-brush',
			'hb-moon-bubble',
			'hb-moon-bubble-10',
			'hb-moon-bubble-11',
			'hb-moon-bubble-12',
			'hb-moon-bubble-13',
			'hb-moon-bubble-2',
			'hb-moon-bubble-3',
			'hb-moon-bubble-4',
			'hb-moon-bubble-5',
			'hb-moon-bubble-6',
			'hb-moon-bubble-7',
			'hb-moon-bubble-8',
			'hb-moon-bubble-9',
			'hb-moon-bubble-blocked',
			'hb-moon-bubble-cancel',
			'hb-moon-bubble-check',
			'hb-moon-bubble-dots',
			'hb-moon-bubble-dots-2',
			'hb-moon-bubble-dots-3',
			'hb-moon-bubble-dots-4',
			'hb-moon-bubble-down',
			'hb-moon-bubble-first',
			'hb-moon-bubble-forward',
			'hb-moon-bubble-forward-2',
			'hb-moon-bubble-heart',
			'hb-moon-bubble-last',
			'hb-moon-bubble-left',
			'hb-moon-bubble-link',
			'hb-moon-bubble-locked',
			'hb-moon-bubble-minus',
			'hb-moon-bubble-notification',
			'hb-moon-bubble-notification-2',
			'hb-moon-bubble-paperclip',
			'hb-moon-bubble-plus',
			'hb-moon-bubble-quote',
			'hb-moon-bubble-replu',
			'hb-moon-bubble-reply',
			'hb-moon-bubble-right',
			'hb-moon-bubble-star',
			'hb-moon-bubble-trash',
			'hb-moon-bubble-up',
			'hb-moon-bubble-user',
			'hb-moon-bubble-video-chat',
			'hb-moon-bubbles',
			'hb-moon-bubbles-10',
			'hb-moon-bubbles-2',
			'hb-moon-bubbles-3',
			'hb-moon-bubbles-4',
			'hb-moon-bubbles-5',
			'hb-moon-bubbles-6',
			'hb-moon-bubbles-7',
			'hb-moon-bubbles-8',
			'hb-moon-bubbles-9',
			'hb-moon-bug',
			'hb-moon-bug-2',
			'hb-moon-bullhorn',
			'hb-moon-bus',
			'hb-moon-busy',
			'hb-moon-busy-2',
			'hb-moon-busy-3',
			'hb-moon-busy-4',
			'hb-moon-cabinet',
			'hb-moon-cake',
			'hb-moon-calculate',
			'hb-moon-calculate-2',
			'hb-moon-calendar',
			'hb-moon-calendar-2',
			'hb-moon-calendar-3',
			'hb-moon-calendar-4',
			'hb-moon-calendar-5',
			'hb-moon-call-incoming',
			'hb-moon-call-outgoing',
			'hb-moon-camera',
			'hb-moon-camera-2',
			'hb-moon-camera-3',
			'hb-moon-camera-4',
			'hb-moon-camera-5',
			'hb-moon-camera-6',
			'hb-moon-camera-7',
			'hb-moon-camera-8',
			'hb-moon-camera-9',
			'hb-moon-cancel',
			'hb-moon-cancel-circle',
			'hb-moon-cancel-circle-2',
			'hb-moon-car',
			'hb-moon-cart',
			'hb-moon-cart-2',
			'hb-moon-cart-3',
			'hb-moon-cart-4',
			'hb-moon-cart-5',
			'hb-moon-cart-6',
			'hb-moon-cart-7',
			'hb-moon-cart-add',
			'hb-moon-cart-checkout',
			'hb-moon-cart-minus',
			'hb-moon-cart-plus',
			'hb-moon-cart-remove',
			'hb-moon-cart-remove-2',
			'hb-moon-cc',
			'hb-moon-cd',
			'hb-moon-certificate',
			'hb-moon-chart',
			'hb-moon-checkbox',
			'hb-moon-checkbox-checked',
			'hb-moon-checkbox-checked-2',
			'hb-moon-checkbox-partial',
			'hb-moon-checkbox-partial-2',
			'hb-moon-checkbox-partial-3',
			'hb-moon-checkbox-unchecked',
			'hb-moon-checkbox-unchecked-2',
			'hb-moon-checkbox-unchecked-3',
			'hb-moon-checkmark',
			'hb-moon-checkmark-2',
			'hb-moon-checkmark-3',
			'hb-moon-checkmark-4',
			'hb-moon-checkmark-circle',
			'hb-moon-checkmark-circle-2',
			'hb-moon-chess',
			'hb-moon-circle',
			'hb-moon-circle-2',
			'hb-moon-circle-small',
			'hb-moon-clear-formatting',
			'hb-moon-clipboard',
			'hb-moon-clipboard-2',
			'hb-moon-clipboard-3',
			'hb-moon-clipboard-4',
			'hb-moon-clock',
			'hb-moon-clock-2',
			'hb-moon-clock-3',
			'hb-moon-clock-4',
			'hb-moon-clock-5',
			'hb-moon-clock-6',
			'hb-moon-clock-7',
			'hb-moon-close',
			'hb-moon-close-2',
			'hb-moon-close-3',
			'hb-moon-close-4',
			'hb-moon-close-5',
			'hb-moon-cloud',
			'hb-moon-cloud-2',
			'hb-moon-cloud-3',
			'hb-moon-cloud-download',
			'hb-moon-cloud-upload',
			'hb-moon-clubs',
			'hb-moon-code',
			'hb-moon-cog',
			'hb-moon-cog-2',
			'hb-moon-cog-3',
			'hb-moon-cog-4',
			'hb-moon-cog-5',
			'hb-moon-cog-6',
			'hb-moon-cog-7',
			'hb-moon-cogs',
			'hb-moon-coin',
			'hb-moon-coins',
			'hb-moon-command',
			'hb-moon-compass',
			'hb-moon-compass-2',
			'hb-moon-cone',
			'hb-moon-confused',
			'hb-moon-confused-2',
			'hb-moon-connection',
			'hb-moon-connection-2',
			'hb-moon-connection-3',
			'hb-moon-console',
			'hb-moon-construction',
			'hb-moon-contact-add',
			'hb-moon-contact-add-2',
			'hb-moon-contact-remove',
			'hb-moon-contact-remove-2',
			'hb-moon-contract',
			'hb-moon-contract-2',
			'hb-moon-contract-3',
			'hb-moon-contrast',
			'hb-moon-cool',
			'hb-moon-cool-2',
			'hb-moon-copy',
			'hb-moon-copy-2',
			'hb-moon-copy-3',
			'hb-moon-copy-4',
			'hb-moon-cord',
			'hb-moon-credit',
			'hb-moon-credit-2',
			'hb-moon-crop',
			'hb-moon-crop-2',
			'hb-moon-crown',
			'hb-moon-cube',
			'hb-moon-cube-2',
			'hb-moon-cube-3',
			'hb-moon-cube4',
			'hb-moon-cup',
			'hb-moon-cup-2',
			'hb-moon-cursor',
			'hb-moon-cursor-2',
			'hb-moon-cylinder',
			'hb-moon-dashboard',
			'hb-moon-database',
			'hb-moon-database-2',
			'hb-moon-database-3',
			'hb-moon-delicious',
			'hb-moon-deviantart',
			'hb-moon-deviantart-2',
			'hb-moon-diamond',
			'hb-moon-diamond-2',
			'hb-moon-diamonds',
			'hb-moon-dice',
			'hb-moon-direction',
			'hb-moon-disk',
			'hb-moon-download',
			'hb-moon-download-2',
			'hb-moon-download-3',
			'hb-moon-download-4',
			'hb-moon-download-5',
			'hb-moon-download-6',
			'hb-moon-download-7',
			'hb-moon-drawer',
			'hb-moon-drawer-2',
			'hb-moon-drawer-3',
			'hb-moon-dribbble',
			'hb-moon-dribbble-2',
			'hb-moon-dribbble-3',
			'hb-moon-droplet',
			'hb-moon-droplet-2',
			'hb-moon-droplet-3',
			'hb-moon-droplet-4',
			'hb-moon-dumbbell',
			'hb-moon-earth',
			'hb-moon-eight-ball',
			'hb-moon-eject',
			'hb-moon-embed',
			'hb-moon-enter',
			'hb-moon-enter-2',
			'hb-moon-enter-3',
			'hb-moon-enter-4',
			'hb-moon-enter-5',
			'hb-moon-envelop',
			'hb-moon-envelop-2',
			'hb-moon-envelop-3',
			'hb-moon-envelop-opened',
			'hb-moon-equalizer',
			'hb-moon-equalizer-2',
			'hb-moon-equalizer-3',
			'hb-moon-esc',
			'hb-moon-evil',
			'hb-moon-evil-2',
			'hb-moon-exclude',
			'hb-moon-exit',
			'hb-moon-exit-2',
			'hb-moon-exit-3',
			'hb-moon-exit-4',
			'hb-moon-expand',
			'hb-moon-expand-2',
			'hb-moon-expand-3',
			'hb-moon-eye',
			'hb-moon-eye-2',
			'hb-moon-eye-3',
			'hb-moon-eye-4',
			'hb-moon-eye-5',
			'hb-moon-eye-6',
			'hb-moon-eye-7',
			'hb-moon-eye-8',
			'hb-moon-eye-blocked',
			'hb-moon-eye-blocked-2',
			'hb-moon-eyedropper',
			'hb-moon-eyedropper-2',
			'hb-moon-facebook',
			'hb-moon-facebook-2',
			'hb-moon-facebook-3',
			'hb-moon-facebook-4',
			'hb-moon-factory',
			'hb-moon-fan',
			'hb-moon-feed',
			'hb-moon-feed-2',
			'hb-moon-feed-3',
			'hb-moon-feed-4',
			'hb-moon-female',
			'hb-moon-file',
			'hb-moon-file-2',
			'hb-moon-file-3',
			'hb-moon-file-4',
			'hb-moon-file-5',
			'hb-moon-file-6',
			'hb-moon-file-7',
			'hb-moon-file-8',
			'hb-moon-file-9',
			'hb-moon-file-check',
			'hb-moon-file-check-2',
			'hb-moon-file-css',
			'hb-moon-file-download',
			'hb-moon-file-download-2',
			'hb-moon-file-excel',
			'hb-moon-file-minus',
			'hb-moon-file-minus-2',
			'hb-moon-file-openoffice',
			'hb-moon-file-pdf',
			'hb-moon-file-plus',
			'hb-moon-file-plus-2',
			'hb-moon-file-powerpoint',
			'hb-moon-file-remove',
			'hb-moon-file-remove-2',
			'hb-moon-file-upload',
			'hb-moon-file-upload-2',
			'hb-moon-file-word',
			'hb-moon-file-xml',
			'hb-moon-file-zip',
			'hb-moon-files',
			'hb-moon-film',
			'hb-moon-film-2',
			'hb-moon-film-3',
			'hb-moon-film-4',
			'hb-moon-filter',
			'hb-moon-filter-2',
			'hb-moon-filter-3',
			'hb-moon-filter-4',
			'hb-moon-finder',
			'hb-moon-fire',
			'hb-moon-fire-2',
			'hb-moon-first',
			'hb-moon-flag',
			'hb-moon-flag-2',
			'hb-moon-flag-3',
			'hb-moon-flag-4',
			'hb-moon-flag-5',
			'hb-moon-flag-6',
			'hb-moon-flattr',
			'hb-moon-flickr',
			'hb-moon-flickr-2',
			'hb-moon-flickr-3',
			'hb-moon-flickr-4',
			'hb-moon-flip',
			'hb-moon-flip-2',
			'hb-moon-flower',
			'hb-moon-folder',
			'hb-moon-folder-2',
			'hb-moon-folder-3',
			'hb-moon-folder-4',
			'hb-moon-folder-5',
			'hb-moon-folder-6',
			'hb-moon-folder-download',
			'hb-moon-folder-download-2',
			'hb-moon-folder-download-3',
			'hb-moon-folder-minus',
			'hb-moon-folder-minus-2',
			'hb-moon-folder-minus-3',
			'hb-moon-folder-open',
			'hb-moon-folder-open-2',
			'hb-moon-folder-open-3',
			'hb-moon-folder-plus',
			'hb-moon-folder-plus-2',
			'hb-moon-folder-plus-3',
			'hb-moon-folder-plus-4',
			'hb-moon-folder-remove',
			'hb-moon-folder-remove-2',
			'hb-moon-folder-upload',
			'hb-moon-folder-upload-2',
			'hb-moon-folder-upload-3',
			'hb-moon-folder8',
			'hb-moon-font',
			'hb-moon-font-size',
			'hb-moon-font-size-2',
			'hb-moon-food',
			'hb-moon-food-2',
			'hb-moon-football',
			'hb-moon-forrst',
			'hb-moon-forrst-2',
			'hb-moon-forward',
			'hb-moon-forward-2',
			'hb-moon-forward-3',
			'hb-moon-foursquare',
			'hb-moon-foursquare-2',
			'hb-moon-fullscreen',
			'hb-moon-gamepad',
			'hb-moon-gamepad-2',
			'hb-moon-gamepad-3',
			'hb-moon-gas-pump',
			'hb-moon-gift',
			'hb-moon-gift-2',
			'hb-moon-github',
			'hb-moon-github-2',
			'hb-moon-github-3',
			'hb-moon-github-4',
			'hb-moon-github-5',
			'hb-moon-glass',
			'hb-moon-glass-2',
			'hb-moon-glasses',
			'hb-moon-glasses-2',
			'hb-moon-glasses-3',
			'hb-moon-globe',
			'hb-moon-globe-2',
			'hb-moon-globe-3',
			'hb-moon-golf',
			'hb-moon-google',
			'hb-moon-google-drive',
			'hb-moon-google-plus',
			'hb-moon-google-plus-2',
			'hb-moon-google-plus-3',
			'hb-moon-google-plus-4',
			'hb-moon-graduation',
			'hb-moon-grid',
			'hb-moon-grid-2',
			'hb-moon-grid-3',
			'hb-moon-grid-4',
			'hb-moon-grid-5',
			'hb-moon-grid-6',
			'hb-moon-grin',
			'hb-moon-grin-2',
			'hb-moon-guitar',
			'hb-moon-gun',
			'hb-moon-gun-ban',
			'hb-moon-hamburger',
			'hb-moon-hammer',
			'hb-moon-hammer-2',
			'hb-moon-hand',
			'hb-moon-hanger',
			'hb-moon-happy',
			'hb-moon-happy-2',
			'hb-moon-headphones',
			'hb-moon-headphones-2',
			'hb-moon-health',
			'hb-moon-heart',
			'hb-moon-heart-2',
			'hb-moon-heart-3',
			'hb-moon-heart-4',
			'hb-moon-heart-5',
			'hb-moon-heart-6',
			'hb-moon-heart-7',
			'hb-moon-heart-8',
			'hb-moon-heart-broken',
			'hb-moon-heart-broken-2',
			'hb-moon-heart-broken-3',
			'hb-moon-height',
			'hb-moon-highlight',
			'hb-moon-history',
			'hb-moon-history-2',
			'hb-moon-hockey',
			'hb-moon-home',
			'hb-moon-home-10',
			'hb-moon-home-11',
			'hb-moon-home-12',
			'hb-moon-home-2',
			'hb-moon-home-3',
			'hb-moon-home-4',
			'hb-moon-home-5',
			'hb-moon-home-6',
			'hb-moon-home-7',
			'hb-moon-home-8',
			'hb-moon-home-9',
			'hb-moon-html5',
			'hb-moon-html5-2',
			'hb-moon-image',
			'hb-moon-image-2',
			'hb-moon-image-3',
			'hb-moon-image-4',
			'hb-moon-image-5',
			'hb-moon-image-6',
			'hb-moon-image-7',
			'hb-moon-images',
			'hb-moon-images-2',
			'hb-moon-indent-decrease',
			'hb-moon-indent-decrease-2',
			'hb-moon-indent-increase',
			'hb-moon-indent-increase-2',
			'hb-moon-info',
			'hb-moon-info-2',
			'hb-moon-inject',
			'hb-moon-inject-2',
			'hb-moon-insert-template',
			'hb-moon-instagram',
			'hb-moon-interset',
			'hb-moon-italic',
			'hb-moon-italic-2',
			'hb-moon-joomla',
			'hb-moon-key',
			'hb-moon-key-2',
			'hb-moon-key-3',
			'hb-moon-key-4',
			'hb-moon-key-5',
			'hb-moon-key-A',
			'hb-moon-key-down',
			'hb-moon-key-keyboard',
			'hb-moon-key-left',
			'hb-moon-key-right',
			'hb-moon-key-up',
			'hb-moon-keyboard',
			'hb-moon-keyboard-2',
			'hb-moon-keyhole',
			'hb-moon-king',
			'hb-moon-knight',
			'hb-moon-lab',
			'hb-moon-ladder',
			'hb-moon-lamp',
			'hb-moon-lamp-2',
			'hb-moon-lamp-3',
			'hb-moon-lamp-4',
			'hb-moon-lanyrd',
			'hb-moon-laptop',
			'hb-moon-last',
			'hb-moon-lastfm',
			'hb-moon-lastfm-2',
			'hb-moon-leaf',
			'hb-moon-leaf-2',
			'hb-moon-left-to-right',
			'hb-moon-library',
			'hb-moon-library-2',
			'hb-moon-libreoffice',
			'hb-moon-lightning',
			'hb-moon-link',
			'hb-moon-link-2',
			'hb-moon-link-3',
			'hb-moon-link-4',
			'hb-moon-link-5',
			'hb-moon-link-6',
			'hb-moon-link2',
			'hb-moon-linkedin',
			'hb-moon-lips',
			'hb-moon-lips-2',
			'hb-moon-list',
			'hb-moon-list-2',
			'hb-moon-list-3',
			'hb-moon-list-4',
			'hb-moon-list-5',
			'hb-moon-location',
			'hb-moon-location-2',
			'hb-moon-location-3',
			'hb-moon-location-4',
			'hb-moon-location-5',
			'hb-moon-location-6',
			'hb-moon-location-7',
			'hb-moon-lock',
			'hb-moon-lock-2',
			'hb-moon-lock-3',
			'hb-moon-lock-4',
			'hb-moon-lock-5',
			'hb-moon-loop',
			'hb-moon-loop-2',
			'hb-moon-loop-3',
			'hb-moon-loop-4',
			'hb-moon-loop-5',
			'hb-moon-magnet',
			'hb-moon-magnet-2',
			'hb-moon-magnet-3',
			'hb-moon-magnet-4',
			'hb-moon-mail',
			'hb-moon-mail-2',
			'hb-moon-mail-3',
			'hb-moon-mail-4',
			'hb-moon-mail-send',
			'hb-moon-male',
			'hb-moon-man',
			'hb-moon-map',
			'hb-moon-map-2',
			'hb-moon-map-3',
			'hb-moon-map-4',
			'hb-moon-marker',
			'hb-moon-marker-2',
			'hb-moon-medal',
			'hb-moon-medal-2',
			'hb-moon-medal-3',
			'hb-moon-medal-4',
			'hb-moon-medal-5',
			'hb-moon-megaphone',
			'hb-moon-menu',
			'hb-moon-menu-10',
			'hb-moon-menu-11',
			'hb-moon-menu-2',
			'hb-moon-menu-3',
			'hb-moon-menu-4',
			'hb-moon-menu-5',
			'hb-moon-menu-6',
			'hb-moon-menu-7',
			'hb-moon-menu-8',
			'hb-moon-menu-9',
			'hb-moon-menu-close',
			'hb-moon-menu-close-2',
			'hb-moon-meter',
			'hb-moon-meter-fast',
			'hb-moon-meter-medium',
			'hb-moon-meter-slow',
			'hb-moon-meter2',
			'hb-moon-mic',
			'hb-moon-mic-2',
			'hb-moon-mic-3',
			'hb-moon-mic-4',
			'hb-moon-mic-5',
			'hb-moon-microscope',
			'hb-moon-minus',
			'hb-moon-minus-2',
			'hb-moon-minus-circle',
			'hb-moon-minus-circle-2',
			'hb-moon-mobile',
			'hb-moon-mobile-2',
			'hb-moon-mobile-3',
			'hb-moon-moon',
			'hb-moon-mouse',
			'hb-moon-mouse-2',
			'hb-moon-mouse-3',
			'hb-moon-mouse-4',
			'hb-moon-move',
			'hb-moon-movie',
			'hb-moon-movie-2',
			'hb-moon-movie-3',
			'hb-moon-mug',
			'hb-moon-music',
			'hb-moon-music-2',
			'hb-moon-music-3',
			'hb-moon-music-4',
			'hb-moon-music-5',
			'hb-moon-music-6',
			'hb-moon-nbsp',
			'hb-moon-network',
			'hb-moon-neutral',
			'hb-moon-neutral-2',
			'hb-moon-new',
			'hb-moon-new-tab',
			'hb-moon-new-tab-2',
			'hb-moon-newspaper',
			'hb-moon-next',
			'hb-moon-notebook',
			'hb-moon-notification',
			'hb-moon-notification-2',
			'hb-moon-numbered-list',
			'hb-moon-office',
			'hb-moon-omega',
			'hb-moon-package',
			'hb-moon-pacman',
			'hb-moon-page-break',
			'hb-moon-page-break-2',
			'hb-moon-pagebreak',
			'hb-moon-paint-format',
			'hb-moon-paint-format-2',
			'hb-moon-palette',
			'hb-moon-palette-2',
			'hb-moon-paper-plane',
			'hb-moon-paragraph-center',
			'hb-moon-paragraph-center-2',
			'hb-moon-paragraph-center-3',
			'hb-moon-paragraph-justify',
			'hb-moon-paragraph-justify-2',
			'hb-moon-paragraph-justify-3',
			'hb-moon-paragraph-left',
			'hb-moon-paragraph-left-2',
			'hb-moon-paragraph-left-3',
			'hb-moon-paragraph-right',
			'hb-moon-paragraph-right-2',
			'hb-moon-paragraph-right-3',
			'hb-moon-paste',
			'hb-moon-paste-2',
			'hb-moon-paste-3',
			'hb-moon-patch',
			'hb-moon-pause',
			'hb-moon-pause-2',
			'hb-moon-paw',
			'hb-moon-pawn',
			'hb-moon-paypal',
			'hb-moon-paypal-2',
			'hb-moon-paypal-3',
			'hb-moon-peace',
			'hb-moon-pen',
			'hb-moon-pen-2',
			'hb-moon-pen-3',
			'hb-moon-pen-4',
			'hb-moon-pen-5',
			'hb-moon-pencil',
			'hb-moon-pencil-2',
			'hb-moon-pencil-3',
			'hb-moon-pencil-4',
			'hb-moon-pencil-5',
			'hb-moon-pencil-6',
			'hb-moon-people',
			'hb-moon-phone',
			'hb-moon-phone-2',
			'hb-moon-phone-3',
			'hb-moon-phone-4',
			'hb-moon-phone-5',
			'hb-moon-phone-6',
			'hb-moon-phone-hang-up',
			'hb-moon-phone-hang-up-2',
			'hb-moon-piano',
			'hb-moon-picassa',
			'hb-moon-picassa-2',
			'hb-moon-pie',
			'hb-moon-pie-2',
			'hb-moon-pie-3',
			'hb-moon-pie-4',
			'hb-moon-pie-5',
			'hb-moon-pie-6',
			'hb-moon-pie-7',
			'hb-moon-pilcrow',
			'hb-moon-pinterest',
			'hb-moon-pinterest-2',
			'hb-moon-play',
			'hb-moon-play-2',
			'hb-moon-play-3',
			'hb-moon-play-4',
			'hb-moon-playlist',
			'hb-moon-plus',
			'hb-moon-plus-2',
			'hb-moon-plus-circle',
			'hb-moon-plus-circle-2',
			'hb-moon-podcast',
			'hb-moon-podcast-2',
			'hb-moon-podcast-3',
			'hb-moon-podium',
			'hb-moon-point-down',
			'hb-moon-point-left',
			'hb-moon-point-right',
			'hb-moon-point-up',
			'hb-moon-pointer',
			'hb-moon-popout',
			'hb-moon-power',
			'hb-moon-power-2',
			'hb-moon-power-cord',
			'hb-moon-previous',
			'hb-moon-print',
			'hb-moon-print-2',
			'hb-moon-print-3',
			'hb-moon-profile',
			'hb-moon-pushpin',
			'hb-moon-puzzle',
			'hb-moon-puzzle-2',
			'hb-moon-puzzle-3',
			'hb-moon-puzzle-4',
			'hb-moon-pyramid',
			'hb-moon-pyramid-2',
			'hb-moon-qrcode',
			'hb-moon-queen',
			'hb-moon-question',
			'hb-moon-question-2',
			'hb-moon-question-3',
			'hb-moon-question-4',
			'hb-moon-question-5',
			'hb-moon-quill',
			'hb-moon-quill-2',
			'hb-moon-quill-3',
			'hb-moon-quotes-left',
			'hb-moon-quotes-right',
			'hb-moon-quotes-right-2',
			'hb-moon-quotes-right-3',
			'hb-moon-racing',
			'hb-moon-radio',
			'hb-moon-radio-2',
			'hb-moon-radio-checked',
			'hb-moon-radio-unchecked',
			'hb-moon-rating',
			'hb-moon-rating-2',
			'hb-moon-rating-3',
			'hb-moon-reading',
			'hb-moon-reddit',
			'hb-moon-redo',
			'hb-moon-redo-2',
			'hb-moon-remove',
			'hb-moon-remove-2',
			'hb-moon-remove-3',
			'hb-moon-remove-4',
			'hb-moon-remove-5',
			'hb-moon-remove-6',
			'hb-moon-remove-7',
			'hb-moon-remove-8',
			'hb-moon-reply',
			'hb-moon-reply-2',
			'hb-moon-resize',
			'hb-moon-resize-2',
			'hb-moon-right-to-left',
			'hb-moon-road',
			'hb-moon-rock',
			'hb-moon-rocket',
			'hb-moon-rotate',
			'hb-moon-rotate-2',
			'hb-moon-rulers',
			'hb-moon-sad',
			'hb-moon-sad-2',
			'hb-moon-scale-down',
			'hb-moon-scale-down-2',
			'hb-moon-scale-up',
			'hb-moon-scale-up-2',
			'hb-moon-scissors',
			'hb-moon-scissors-2',
			'hb-moon-scissors-3',
			'hb-moon-screen',
			'hb-moon-screen-2',
			'hb-moon-screen-3',
			'hb-moon-screen-4',
			'hb-moon-screwdriver',
			'hb-moon-screwdriver-2',
			'hb-moon-search',
			'hb-moon-search-2',
			'hb-moon-search-3',
			'hb-moon-search-4',
			'hb-moon-search-5',
			'hb-moon-settings',
			'hb-moon-seven-segment-0',
			'hb-moon-seven-segment-1',
			'hb-moon-seven-segment-2',
			'hb-moon-seven-segment-3',
			'hb-moon-seven-segment-4',
			'hb-moon-seven-segment-5',
			'hb-moon-seven-segment-6',
			'hb-moon-seven-segment-7',
			'hb-moon-seven-segment-8',
			'hb-moon-seven-segment-9',
			'hb-moon-share',
			'hb-moon-share-2',
			'hb-moon-share-3',
			'hb-moon-shield',
			'hb-moon-shield-2',
			'hb-moon-shield-3',
			'hb-moon-shield-4',
			'hb-moon-ship',
			'hb-moon-shocked',
			'hb-moon-shocked-2',
			'hb-moon-shuffle',
			'hb-moon-shuffle-2',
			'hb-moon-sigma',
			'hb-moon-signup',
			'hb-moon-skull',
			'hb-moon-skull-2',
			'hb-moon-skull-3',
			'hb-moon-skype',
			'hb-moon-smiley',
			'hb-moon-smiley-2',
			'hb-moon-snowflake',
			'hb-moon-soccer',
			'hb-moon-socket',
			'hb-moon-sort',
			'hb-moon-sort-2',
			'hb-moon-soundcloud',
			'hb-moon-soundcloud-2',
			'hb-moon-spades',
			'hb-moon-spam',
			'hb-moon-spell-check',
			'hb-moon-spinner',
			'hb-moon-spinner-10',
			'hb-moon-spinner-11',
			'hb-moon-spinner-12',
			'hb-moon-spinner-2',
			'hb-moon-spinner-3',
			'hb-moon-spinner-4',
			'hb-moon-spinner-5',
			'hb-moon-spinner-6',
			'hb-moon-spinner-7',
			'hb-moon-spinner-8',
			'hb-moon-spinner-9',
			'hb-moon-spotlight',
			'hb-moon-square',
			'hb-moon-stack',
			'hb-moon-stack-2',
			'hb-moon-stack-3',
			'hb-moon-stack-4',
			'hb-moon-stack-cancel',
			'hb-moon-stack-checkmark',
			'hb-moon-stack-clubs',
			'hb-moon-stack-diamonds',
			'hb-moon-stack-down',
			'hb-moon-stack-empty',
			'hb-moon-stack-hearts',
			'hb-moon-stack-list',
			'hb-moon-stack-minus',
			'hb-moon-stack-music',
			'hb-moon-stack-picture',
			'hb-moon-stack-play',
			'hb-moon-stack-plus',
			'hb-moon-stack-spades',
			'hb-moon-stack-star',
			'hb-moon-stack-up',
			'hb-moon-stack-user',
			'hb-moon-stackoverflow',
			'hb-moon-stairs',
			'hb-moon-stairs-2',
			'hb-moon-stairs-down',
			'hb-moon-stairs-down-2',
			'hb-moon-star',
			'hb-moon-star-2',
			'hb-moon-star-3',
			'hb-moon-star-4',
			'hb-moon-star-5',
			'hb-moon-star-6',
			'hb-moon-starburst',
			'hb-moon-stats',
			'hb-moon-stats-2',
			'hb-moon-stats-3',
			'hb-moon-stats-down',
			'hb-moon-stats-up',
			'hb-moon-steam',
			'hb-moon-steam-2',
			'hb-moon-steps',
			'hb-moon-stop',
			'hb-moon-stop-2',
			'hb-moon-stopwatch',
			'hb-moon-storage',
			'hb-moon-storage-2',
			'hb-moon-strikethrough',
			'hb-moon-strikethrough-2',
			'hb-moon-strikethrough-3',
			'hb-moon-stumbleupon',
			'hb-moon-stumbleupon-2',
			'hb-moon-subscript',
			'hb-moon-subscript-2',
			'hb-moon-subtract',
			'hb-moon-sun',
			'hb-moon-sun-2',
			'hb-moon-sun-glasses',
			'hb-moon-superscript',
			'hb-moon-superscript-2',
			'hb-moon-support',
			'hb-moon-switch',
			'hb-moon-tab',
			'hb-moon-table',
			'hb-moon-table-2',
			'hb-moon-tablet',
			'hb-moon-tag',
			'hb-moon-tag-2',
			'hb-moon-tag-3',
			'hb-moon-tag-4',
			'hb-moon-tag-5',
			'hb-moon-tag-6',
			'hb-moon-tag-7',
			'hb-moon-tag-8',
			'hb-moon-tags',
			'hb-moon-tags-2',
			'hb-moon-target',
			'hb-moon-target-2',
			'hb-moon-target-3',
			'hb-moon-temperature',
			'hb-moon-temperature-2',
			'hb-moon-text-color',
			'hb-moon-text-height',
			'hb-moon-text-width',
			'hb-moon-thumbs-down',
			'hb-moon-thumbs-down-2',
			'hb-moon-thumbs-up',
			'hb-moon-thumbs-up-2',
			'hb-moon-thumbs-up-3',
			'hb-moon-thumbs-up-4',
			'hb-moon-thumbs-up-5',
			'hb-moon-thumbs-up-6',
			'hb-moon-ticket',
			'hb-moon-tiktok',
			'hb-moon-tongue',
			'hb-moon-tongue-2',
			'hb-moon-tools',
			'hb-moon-train',
			'hb-moon-transmission',
			'hb-moon-transmission-2',
			'hb-moon-tree',
			'hb-moon-tree-2',
			'hb-moon-tree-3',
			'hb-moon-tree-4',
			'hb-moon-tree-5',
			'hb-moon-trophy',
			'hb-moon-trophy-2',
			'hb-moon-trophy-star',
			'hb-moon-truck',
			'hb-moon-tshirt',
			'hb-moon-tumblr',
			'hb-moon-tumblr-2',
			'hb-moon-tux',
			'hb-moon-tv',
			'hb-moon-twitter',
			'hb-moon-twitter-2',
			'hb-moon-twitter-3',
			'hb-moon-type',
			'hb-moon-umbrella',
			'hb-moon-underline',
			'hb-moon-underline-2',
			'hb-moon-undo',
			'hb-moon-undo-2',
			'hb-moon-unite',
			'hb-moon-unlocked',
			'hb-moon-unlocked-2',
			'hb-moon-upload',
			'hb-moon-upload-2',
			'hb-moon-upload-3',
			'hb-moon-upload-4',
			'hb-moon-upload-5',
			'hb-moon-upload-6',
			'hb-moon-upload-7',
			'hb-moon-user',
			'hb-moon-user-2',
			'hb-moon-user-3',
			'hb-moon-user-4',
			'hb-moon-user-5',
			'hb-moon-user-6',
			'hb-moon-user-7',
			'hb-moon-user-8',
			'hb-moon-user-block',
			'hb-moon-user-block-2',
			'hb-moon-user-cancel',
			'hb-moon-user-cancel-2',
			'hb-moon-user-minus',
			'hb-moon-user-minus-2',
			'hb-moon-user-minus-3',
			'hb-moon-user-plus',
			'hb-moon-user-plus-2',
			'hb-moon-user-plus-3',
			'hb-moon-users',
			'hb-moon-users-2',
			'hb-moon-users-3',
			'hb-moon-users-4',
			'hb-moon-users-5',
			'hb-moon-vcard',
			'hb-moon-vector',
			'hb-moon-vimeo',
			'hb-moon-vimeo-2',
			'hb-moon-vimeo2',
			'hb-moon-volume-decrease',
			'hb-moon-volume-decrease-2',
			'hb-moon-volume-high',
			'hb-moon-volume-high-2',
			'hb-moon-volume-increase',
			'hb-moon-volume-increase-2',
			'hb-moon-volume-low',
			'hb-moon-volume-low-2',
			'hb-moon-volume-medium',
			'hb-moon-volume-medium-2',
			'hb-moon-volume-mute',
			'hb-moon-volume-mute-2',
			'hb-moon-volume-mute-3',
			'hb-moon-volume-mute-4',
			'hb-moon-volume-mute-5',
			'hb-moon-volume-mute-6',
			'hb-moon-volume0',
			'hb-moon-volume1',
			'hb-moon-volume2',
			'hb-moon-volume3',
			'hb-moon-volume4',
			'hb-moon-volume5',
			'hb-moon-wand',
			'hb-moon-wand-2',
			'hb-moon-warning',
			'hb-moon-warning-2',
			'hb-moon-watch',
			'hb-moon-wave',
			'hb-moon-wave-2',
			'hb-moon-weather-lightning',
			'hb-moon-weather-rain',
			'hb-moon-weather-snow',
			'hb-moon-width',
			'hb-moon-windows',
			'hb-moon-windows8',
			'hb-moon-windy',
			'hb-moon-wink',
			'hb-moon-wink-2',
			'hb-moon-woman',
			'hb-moon-wondering',
			'hb-moon-wondering-2',
			'hb-moon-wordpress',
			'hb-moon-wordpress-2',
			'hb-moon-wrench',
			'hb-moon-wrench-2',
			'hb-moon-wrench-3',
			'hb-moon-wrench-4',
			'hb-moon-xing',
			'hb-moon-xing-2',
			'hb-moon-yahoo',
			'hb-moon-yelp',
			'hb-moon-yin-yang',
			'hb-moon-youtube',
			'hb-moon-youtube-2',
			'hb-moon-zoom-in',
			'hb-moon-zoom-in-2',
			'hb-moon-zoom-out',
			'hb-moon-zoom-out-2'
		);
	}
}